package com.bakinsbits.example;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.UnicastRemoteObject;

import com.bakinsbits.example.RmiStarter;

/**
 * start the server component. this exposes the an implementation of the Compute interface as a service over RMI
 */
public class TableStarter extends RmiStarter {

    public TableStarter() {
        super(Table.class);
    }

    @Override
    public void doCustomRmiHandling() {
        try {
            Table table = new TableImpl();
            Table tableStub = (Table)UnicastRemoteObject.exportObject(table, 0);

            Registry registry = LocateRegistry.getRegistry();
            registry.rebind(Table.SERVICE_NAME, tableStub);
        }
        catch(Exception e) {
            e.printStackTrace();
        }

    }

    public static void main(String[] args) {
    	System.out.println("TableStarter: starting");
        new TableStarter();
    }
}