package com.bakinsbits.example;

import java.io.Serializable;
import java.rmi.RemoteException;

public class PlayerWrapper implements Player, Serializable {

	private static final long serialVersionUID = -2780039719847069859L;

	private final String name;
	private final Player player;
	
	public PlayerWrapper(String name, Player player) {
		if (null == name) throw new IllegalArgumentException("name");
		if (null == player) throw new IllegalArgumentException("player");
		this.name = name;
		this.player = player;
	}

	@Override
	public void deck(int[] cards) throws RemoteException {
		if (null == cards) throw new IllegalArgumentException("cards");
		player.deck(cards);
	}

	@Override
	public void ping() throws RemoteException {
		player.ping();
	}
	
	@Override
	public String toString() {
		return String.format("player(%s)", name);
	}
}
