package com.bakinsbits.example;

import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.Unreferenced;

public class DealerImpl implements Dealer, Serializable, Unreferenced {

	private static final long serialVersionUID = 2409896939044146154L;

	private TableImpl table;
	private PlayerWrapper player;

	public DealerImpl() throws RemoteException {
		super();
		System.out.println("DealerImpl: constructor");
	}

	public void setTable(TableImpl table) {
		this.table = table;
	}
	
	public void setPlayer(PlayerWrapper player) {
		this.player = player;
	}

	@Override
	public void shuffle() throws RemoteException {
		System.out.println(String.format("DealerImpl for %s: shuffle on %s", player, table));
		if (null != table) {
			table.shuffle();
		}
	}

	@Override
	public void getDeck() throws RemoteException {
		System.out.println(String.format("DealerImpl for %s: getDeck on %s", player, table));
		if (null != table) {
			table.getDeck(player);
		}
	}

	@Override
	public void leaveTable() throws RemoteException {
		System.out.println(String.format("DealerImpl for %s: leaveTable on %s", player, table));
		if (null != table && null != player) {
			table.leaveTable(player);
		}
	}

	@Override
	public void unreferenced() {
		System.out.println(String.format("DealerImpl for %s: unreferenced on %s", player, table));
		try {
			leaveTable();
		} catch (RemoteException e) {
		}
	}

}
