package com.bakinsbits.example;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

import com.bakinsbits.example.RmiStarter;
import com.bakinsbits.example.Table;

/**
 * start the server component. this exposes the an implementation of the Compute interface as a service over RMI
 */
public class PlayerStarter extends RmiStarter {

	private String name;
	private PlayerImpl player;
	private Table table;
	
    public PlayerStarter(String name) {
        super(Player.class);
        this.name = name;
        System.out.println(String.format("PlayerStarter: constructor(%s)", this.name));
    }

    @Override
    public void doCustomRmiHandling() {
    	System.out.println("PlayerStarter: doCustomRmiHandling");
        try {
            Registry registry = LocateRegistry.getRegistry();
            table = (Table)registry.lookup(Table.SERVICE_NAME);
            table.ping();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    public void play() {
    	System.out.println("PlayerStarter: starting play for " + name);
        player = new PlayerImpl(name, table);
        table = null;
    	player.startPlayer();
    	player.REPL();
    	player.endPlayer();
    }

    public static void main(String[] args) {
    	System.out.println("PlayerStarter: starting player " + args[0]);
        new PlayerStarter(args[0]).play();
    }
}