package com.bakinsbits.example;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.rmi.RemoteException;
import java.rmi.server.UnicastRemoteObject;

public class PlayerImpl implements Player, Serializable {

	private static final long serialVersionUID = 6740335282901472046L;
	private final String name;
	private transient Table table;
	private transient Dealer dealer;
	
	public PlayerImpl(String name, Table table) {
		this.name = name;
		this.table = table;
        try {
			UnicastRemoteObject.exportObject((Player)this, 0);
		} catch (RemoteException e) {
			Throw("can't register callback object", e);
		}
	}
	
	public void startPlayer() {
		System.out.println(String.format("Player %s: startPlayer", name));
		try {
			dealer = table.joinTable(name, this);
		} catch (RemoteException e) {
			Throw("can't join table", e);
		}
		System.out.println(String.format("Player %s: startPlayer - joined table, getting deck", name));
		try {
			dealer.getDeck();
		} catch (RemoteException e) {
			Throw("can't get deck", e);
		}
		System.out.println(String.format("Player %s: startPlayer - requested deck", name));
	}
	
	public void REPL() {
		BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
		String line;
		System.out.println("X<return> to exit, otherwise <return> to shuffle:");
		try {
			while (null != (line = br.readLine())) {
				if ("X".equalsIgnoreCase(line)) {
					return;
				}
				try {
					dealer.shuffle();
				} catch (RemoteException e) {
					Throw("couldn't shuffle", e);
				}
			}
		} catch (IOException e) {
			Throw("REPL - oh pooh, error reading console", e);
		}
	}
	
	public void endPlayer() {
		if (null != dealer) {
			try {
				dealer.leaveTable();
			} catch (RemoteException e) {
				Throw("can't leave table", e);
			}
			dealer = null;
		}
		if (null != table) {
			table = null;
		}
        try {
			UnicastRemoteObject.unexportObject((Player)this, true);
		} catch (RemoteException e) {
			Throw("can't register callback", e);
		}
	}

	@Override
	public void deck(int[] cards) throws RemoteException {
		Deck deck = Deck.deckFromArray(cards);
		System.out.println(String.format("Player %s has new deck: %s", name, deck.toAsciiString()));
	}

	@Override
	public void ping() throws RemoteException {
		System.out.println(String.format("Player %s: ping!", name));
	}
	
	private void Throw(String msg, Exception e) {
		System.out.println(String.format("Player %s: %s - %s", name, msg, e));
		throw new RuntimeException(String.format("Player %s: %s", name, msg), e);
	}
}
