package com.bakinsbits.example;

import java.awt.BorderLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Random;

import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class PlayerWindow extends JFrame implements ActionListener, DeckListener {

	private static final long serialVersionUID = 6468518807420824091L;

	private final JButton exitButton;
	private final JButton shuffleButton;
	private final JLabel statusLabel = new JLabel();
	
	private PlayerUIStarter playerStarter;
	private PlayerUIImpl player;
	
	public PlayerWindow(String name) {
		super(name);

		setSize(1600, 1600);
		
		addWindowListener(
				new WindowAdapter() {
					public void windowClosing(WindowEvent event) { 
						exit();
					}
				});
		
		JPanel box = new JPanel();
		box.setLayout(new BoxLayout(box, BoxLayout.Y_AXIS));
		getContentPane().add(box);
		
		box.add(statusLabel, BorderLayout.NORTH);
		statusLabel.setText(" ");
		
		shuffleButton = new JButton("shuffle");
		box.add(shuffleButton);
        shuffleButton.addActionListener(this);
        
		exitButton = new JButton("exit");
		box.add(exitButton);
		exitButton.addActionListener(this);
		
		pack();
		setSize(1175, 120);
		
		playerStarter = new PlayerUIStarter(name);
		player = playerStarter.makePlayer();
		player.startPlayer(this);
	}
	
	@Override
	public void actionPerformed(ActionEvent event) {
		if (event.getSource() == shuffleButton) {
			statusLabel.setText("shuffle pressed!");
			shuffle();
		} else if (event.getSource() == exitButton) {
			statusLabel.setText("exit pressed!");
			exit();
		}
	}
	
	private void shuffle() {
		player.shuffle();
	}
	
	public void setDeck(Deck deck) {
		String rep = deck.toString();
		statusLabel.setText(rep);
	}
	
	private void exit() {
		player.endPlayer();
		player = null;
		playerStarter = null;
		System.exit(0);
	}

	private static String randomPlayerName() {
		return String.format("Player %d", new Random().nextInt(1000));
	}
	
	public static void main(String[] args)
	{
		new PlayerWindow(args.length > 0 ? args[0] : randomPlayerName()).setVisible(true);
	}
}
