package com.bakinsbits.example;

import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;

import com.bakinsbits.example.RmiStarter;
import com.bakinsbits.example.Table;

/**
 * start the server component. this exposes the an implementation of the Compute interface as a service over RMI
 */
public class PlayerUIStarter extends RmiStarter {

	private String name;
	private PlayerUIImpl player;
	private Table table;
	
    public PlayerUIStarter(String name) {
        super(Player.class);
        this.name = name;
        System.out.println(String.format("PlayerUIStarter: constructor(%s)", this.name));
    }

    @Override
    public void doCustomRmiHandling() {
    	System.out.println("PlayerUIStarter: doCustomRmiHandling");
        try {
            Registry registry = LocateRegistry.getRegistry();
            table = (Table)registry.lookup(Table.SERVICE_NAME);
            table.ping();
        }
        catch(Exception e) {
            e.printStackTrace();
        }
    }
    
    public PlayerUIImpl makePlayer() {
    	System.out.println("PlayerUIStarter: makePlayer for " + name);
    	player = new PlayerUIImpl(name, table);
    	table = null;
    	return player;
    }
}