package com.bakinsbits.example;

import java.rmi.Remote;

/**
 * Registration interface to a server implementing a card game at a table.
 */
public interface Table extends Remote {
	
	public static final String SERVICE_NAME = "Table";
	
	/**
	 * Notifies the table (server) that the player is joining the game.
	 * @param name Name of the player (for indentification in diagnostics)
	 * @param player The callback interface so the Table can inform the player of the state of the deck
	 * @return The returned Dealer is how the player interacts with the game
	 * @throws java.rmi.RemoteException
	 */
	public Dealer joinTable(String name, Player player) throws java.rmi.RemoteException;
	
	/**
	 * Just for testing purposes
	 */
	public void ping() throws java.rmi.RemoteException;
}
