package com.bakinsbits.example;

import com.bakinsbits.example.PolicyFileLocator;

public abstract class RmiStarter {

    /**
     *
     * @param clazzToAddToServerCodebase a class that should be in the java.rmi.server.codebase property.
     */
    @SuppressWarnings("rawtypes")
	public RmiStarter(Class clazzToAddToServerCodebase) {

    	String clazzPath = clazzToAddToServerCodebase
                .getProtectionDomain().getCodeSource().getLocation().toString();
    	System.out.println("clazzPath = " + clazzPath);
    	clazzPath = clazzPath.replaceFirst("file:/([a-zA-Z]):/", "file:/$1:/");
    	System.out.println("clazzPath (fixed) = " + clazzPath);
    	
    	System.out.println("java.rmi.server.codebase (was) = " + System.getProperty("java.rmi.server.codebase"));
        //System.setProperty("java.rmi.server.codebase", clazzPath);
    	System.out.println("java.rmi.server.codebase (is) = " + System.getProperty("java.rmi.server.codebase"));

        String policyPath = PolicyFileLocator.getLocationOfPolicyFile();
        System.out.println("policyPath = " + policyPath);
        System.setProperty("java.security.policy", policyPath);

        if(System.getSecurityManager() == null) {
            System.setSecurityManager(new SecurityManager());
        }

        doCustomRmiHandling();
    }

    /**
     * extend this class and do RMI handling here
     */
    public abstract void doCustomRmiHandling();

}
