package com.bakinsbits.example;

import java.rmi.Remote;

/**
 * Callback interface from the Table (server implementing a card game) to a Player.
 */
public interface Player extends Remote {
	
	/**
	 * Gives the player the current value of the deck.
	 * @param cards 52-element array containing all integers in the range 0..51, the shuffled deck
	 * @throws java.rmi.RemoteException
	 */
	public void deck(int[] cards) throws java.rmi.RemoteException;

	/**
	 * Just for testing purposes
	 */
	public void ping() throws java.rmi.RemoteException;
}
