package com.bakinsbits.example;

import java.util.ArrayList;
import java.util.Random;
//import java.io.PrintStream;
//import java.io.UnsupportedEncodingException;

/**
 * Implements a deck of cards, including a shuffle.
 */
public class Deck {
	
	public static final char SUIT_SPADE   = '\u2660';
	public static final char SUIT_HEART   = '\u2665';  // I would prefer white heart and white diamond but they don't work!
	public static final char SUIT_DIAMOND = '\u2666';
	public static final char SUIT_CLUB    = '\u2663';
	public static final String CARD_VALUES = "23456789XJQKA";	
	public static final String ALL_CARDS;
	
	static {
		String suits = "" + SUIT_SPADE + SUIT_HEART + SUIT_DIAMOND + SUIT_CLUB;
		StringBuilder sb = new StringBuilder();
		for (int s = 0; s < 4; s++) {
			for (int v = 0; v < 13; v++) {
				sb.append(CARD_VALUES.charAt(v));
				sb.append(suits.charAt(s));
			}
		}
		ALL_CARDS = sb.toString();
	}
	
	public Deck() {
		this.deck = shuffleADeck();
		validate();
	}
	
	private Deck(int[] a) {
		this.deck = a;
		validate();
	}
	
	public static Deck deckFromArray(int[] a) {
		return new Deck(a);
	}
	
	public void shuffle() {
		this.deck = shuffleADeck();
		validate();
	}
	
	public int[] getCards() {
		return this.deck.clone();
	}
	
	@Override
	public String toString() {
		StringBuilder sb = new StringBuilder(52*2);
		for (int i : this.deck) {
			String thisCard = ALL_CARDS.substring(i*2, i*2+2);
			if ('X' == thisCard.charAt(0)) thisCard = "10" + thisCard.charAt(1);
			sb.append(thisCard);
			sb.append(' ');
		}
		sb.deleteCharAt(sb.length()-1);
		return sb.toString();
	}
	
	public String toAsciiString() {
		return toString().replace(SUIT_SPADE, 'S').replace(SUIT_HEART, 'H').replace(SUIT_DIAMOND, 'D').replace(SUIT_CLUB, 'C');
	}
	
	private int[] deck;
	
	private int[] shuffleADeck() {
		ArrayList<Integer> cleanDeck = new ArrayList<Integer>(52);
		for (int i = 0; i < 52; i++) {
			cleanDeck.add(i);
		}
		
		Random rand = new Random();
		int[] deck = new int[52];
		
		for (int i = 0; i < 52; i++) {
			int j = rand.nextInt(cleanDeck.size());
			deck[i] = cleanDeck.get(j);
			cleanDeck.remove(j);
		}
		
		return deck;
	}
	
	private void validate() {
		if (null == deck) throw new IllegalStateException("null deck");
		if (52 != deck.length) throw new IllegalStateException("wrong length deck");
		for (int i = 0; i < 52; i++) if (deck[i] < 0 || deck[i] >= 52) throw new IllegalStateException("invalid card value(s)");
		boolean[] v = new boolean[52];
		for (int i = 0; i < 52; i++) v[deck[i]] = true;
		for (int i = 0; i < 52; i++) if (!v[i]) throw new IllegalStateException("missing/duplicate cards");
	}
	
//	public static void main(String[] args) {
//		PrintStream ps;
//		try {
//			ps = new PrintStream(System.out, false, "UTF-8");
//		} catch (UnsupportedEncodingException e) {
//			e.printStackTrace();
//			return;
//		}
//		ps.println(String.format("ALL_CARDS: '%s'", ALL_CARDS));
//		for (int i = 1; i < 10; i++) {
//			Deck deck = new Deck();
//			ps.println(String.format("Deck %2d: %s", i, deck));
//			deck.shuffle();
//			ps.println(String.format("shuffled: %s", deck));
//		}
//	}

}
