package com.bakinsbits.example;

import java.rmi.Remote;

/**
 * Action interface to a server implementing a card game at a table.
 */
public interface Dealer extends Remote {
	
	/**
	 * Causes the deck to be shuffled.  You'll get a callback
	 * on Player.deck().
	 * @throws java.rmi.RemoteException
	 * @see Player
	 */
	public void shuffle() throws java.rmi.RemoteException;
	
	/**
	 * Asks for the current deck.  You'll get a callback on Player.deck();
	 * @throws java.rmi.RemoteException
	 * @see Player
	 */
	public void getDeck() throws java.rmi.RemoteException;
	
	/**
	 * Notifies the table (server) that the player is leaving the game.
	 * @throws java.rmi.RemoteException
	 */
	public void leaveTable() throws java.rmi.RemoteException;

}
