package com.bakinsbits.example;

public final class TestDriver {

	private static final Node<String> root;
	private static final String breadthFirst;
	private static final String breadthFirstLevelReversed;
	
	private static Node<String> nn(String data) {
		return new Node<String>(data);
	}
	
	private static Node<String> nn(String data, Node<String> left, Node<String> right) {
		return new Node<String>(data, left, right);
	}
	
	static {
		Node<String> K = nn("K"),
		             L = nn("L"),
		             M = nn("M"),
		             N = nn("N"),
		             G = nn("G"),
		             H = nn("H", K, L),
		             I = nn("I", M, N),
		             J = nn("J"),
		             D = nn("D", G, H),
		             E = nn("E"),
		             F = nn("F", I, J),
		             B = nn("B", D, null),
		             C = nn("C", E, F),
		             A = nn("A", B, C);
		root = A;
		breadthFirst = "ABCDEFGHIJKLMN";
		breadthFirstLevelReversed = "ABCFEDGHIJNMLK";
	}
	
	private class Accumulator implements Visit<String> {
		
		private final StringBuilder sb = new StringBuilder();
		
		@Override
		public void isit(final String data) {
			if (null == data) throw new IllegalArgumentException("data is null");
			sb.append(data);
		}
		
		@Override
		public String toString() {
			return sb.toString();
		}
		
	}
	
	private void tryTraversal(final String kind, final Traverse<String> t, final Node<String> root, final String expected) {
		if (null == t) throw new IllegalArgumentException("t is null");
		if (null == root) throw new IllegalArgumentException("root is null");
		if (null == expected) throw new IllegalArgumentException("expected is null");
		
		final Accumulator acc = new Accumulator();
		t.raverse(acc, root);
		String result = acc.toString();
		System.out.println(String.format("Traversal %s %s: expected %s, result %s",
				kind, expected.equals(result) ? "succeeded" : "failed", expected, result));
	}

	public static void main(String[] args) {
		System.out.println("Start.");
		final TestDriver td = new TestDriver();
		td.tryTraversal("RootOnlyTraversal", new RootOnlyTraversal<String>(), root, "A");
		td.tryTraversal("BreadthFirstTraversal", new BreadthFirstTraversal<String>(), root, breadthFirst);
		td.tryTraversal("BadBreadthFirstAlternateDirectionsTraversal", new BadBreadthFirstAlternateDirectionsTraversal<String>(), root, breadthFirstLevelReversed);
		td.tryTraversal("BreadthFirstAlternateDirectionsTraversal", new BreadthFirstAlternateDirectionsTraversal<String>(), root, breadthFirstLevelReversed);
		td.tryTraversal("BreadthFirstAlternateDirectionsTraversal2", new BreadthFirstAlternateDirectionsTraversal2<String>(), root, breadthFirstLevelReversed);
		System.out.println("Done.");
	}

}
