package com.bakinsbits.example;

import java.util.ArrayDeque;

public class BreadthFirstAlternateDirectionsTraversal2<D> implements Traverse<D> {

	public BreadthFirstAlternateDirectionsTraversal2() {}
	
	@Override
	public void raverse(final Visit<D> v, final Node<D> root) {
		if (null == v) throw new IllegalArgumentException("v is null");
		if (null == root) throw new IllegalArgumentException("root is null");
		
		@SuppressWarnings("serial")
		abstract class Level extends ArrayDeque<Node<D>>{
			
			public Level other;
			
			public Level() {}
			
			protected abstract Node<D> first(Node<D> n);
			protected abstract Node<D> second(Node<D> n);
			
			public void doNode(Node<D> n) {
				if (null != n) {
					v.isit(n.data);
					other.push(n);
				}
			}
			
			public Level doLevel() {
				if (null == other) throw new IllegalStateException("other is null");
				while (!isEmpty()) {
					final Node<D> n = pop();
					doNode(first(n));
					doNode(second(n));
				}
				clear();
				return other;
			}
		}

		@SuppressWarnings("serial")
		final Level lr = new Level(){
			@Override protected Node<D> first(Node<D> n) { return n.left; }
			@Override protected Node<D> second(Node<D> n) { return n.right; }
		};

		@SuppressWarnings("serial")
		final Level rl = new Level(){
			@Override protected Node<D> first(Node<D> n) { return n.right; }
			@Override protected Node<D> second(Node<D> n) { return n.left; }
		};

		lr.other = rl;
		rl.other = lr;
		
		rl.doNode(root);
		Level stk = lr;
		while (!stk.isEmpty()) {
			stk = stk.doLevel();
		}
	}

}
