-- Gibbons' Unbounded Spigot Algorithm(s) for pi
-- (corrected from paper)

import Data.Ratio

stream :: (b->c) -> (b->c->Bool) -> (b->c->b) -> (b->a->b) -> b -> [a] -> [c]
stream next safe prod cons z (x:xs)
  = if safe z y
    then y : stream next safe prod cons (prod z y) (x:xs)
    else     stream next safe prod cons (cons z x) xs
      where y = next z

type LFT = (Integer, Integer, Integer, Integer)

extr :: LFT -> Integer -> Rational
extr (q,r,s,t) x = (q*x + r) % (s*x + t)
--                           ^ typo in paper, was /

extrR :: LFT -> Rational -> Rational
extrR (q,r,s,t) x = (fromInteger q * x + fromInteger r) / (fromInteger s * x + fromInteger t)

unit :: LFT
unit = (1,0,0,1)

comp :: LFT -> LFT -> LFT
comp (q,r,s,t) (u,v,w,x) = (q*u+r*w,q*v+r*x,s*u+t*w,s*v+t*x)

pi = stream next safe prod cons init ltfs where
  init      = unit
  ltfs      = [(k, 4*k+2, 0, 2*k+1) | k <- [1..]]
  next z    = floor (extr z 3)
  safe z n  = (n == floor (extr z 4))
  prod z n  = comp (10, -10*n, 0, 1) z
  cons z z' = comp z z'

piObfus = g(1,0,1,1,3,3) where
  g(q,r,t,k,n,l) = if 4*q+r-t<n*t
    then n : g(10*q,10*(r-n*t),t,k,div(10*(3*q+r))t-10*n,l)
    else g(q*k,(2*q+r)*l,t*l,k+1,div(q*(7*k+2)+r*l)(t*l),l+2)

piL = stream next safe prod cons init lfts where
  init                 = ((0,4,1,0), 1)
  lfts                 = [(2*i-1, i*i, 1, 0) | i <- [1..]]
  next ((q,r,s,t),i)   = floor ((q*x+r) % (s*x+t)) where x = 2*i-1
  safe ((q,r,s,t),i) n = (n == floor ((q*x+2*r) % (s*x+2*t))) where x = 5*i-2
  prod (z,i) n         = (comp (10, -10*n, 0, 1) z, i)
  cons (z,i) z'        = (comp z z', i+1)
  
piG = stream next safe prod cons init lfts where
  init                 = ((1,0,0,1), 1)
  lfts                 = [let j = 3*(3*i+1)*(3*i+2)
                            in (i*(2*i-1),j*(5*i-2),0,j) | i <- [1..]]
--next ((q,r,s,t),i)   = div (q*x+5*r) (s*x+5*t) where x = 27*i-12
--                                                             ^^^ typo in paper, was +15
  next ((q,r,s,t),i)   = floor (extrR (q,r,s,t) ((27*i-12)%5))
--safe ((q,r,s,t),i) n = (n == div (q*x+125*r) (s*x+125*t)) where x = 675*i-216
  safe ((q,r,s,t),i) n = (n == floor ( extrR (q,r,s,t) ((675*i-216)%125) ))
  prod (z,i) n         = (comp (10, -10*n, 0, 1) z, i)
  cons (z,i) z'        = (comp z z', i+1)

piG2 = process next prod cons init lfts where
  init                 = ((1,0,0,1), 1)
  lfts                 = [let j = 3*(3*i+1)*(3*i+2)
                            in (i*(2*i-1),j*(5*i-2),0,j) | i <- [1..]]
--next ((q,r,s,t),i)   = div (q*x+5*r) (s*x+5*t) where x = 27*i-12
--                                                             ^^^ typo in paper, was +15
  next ((q,r,s,t),i)   = floor ((q*x+5*r) % (s*x+5*t)) where x = 27*i-12
  prod (z,i) n         = (comp (10, -10*n, 0, 1) z, i)
  cons (z,i) z'        = (comp z z', i+1)

process next prod cons u (x:xs)
  = y : process next prod cons (prod v y) xs
    where v = cons u x
          y = next v

piG3 = g(1,180,60,2) where
  g(q,r,t,i) = let (u,y) = ( 3*(3*i+1)*(3*i+2), div (q*(27*i-12)+5*r) (5*t) )
               in y : g(10*q*i*(2*i-1), 10*u*(q*(5*i-2)+r-y*t), t*u, i+1)
