package com.bakinsbits.spigot;

import static java.lang.System.out;

import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;

public class BaseConversion implements
		StreamingAlgorithm.NextInput<Integer>,
		StreamingAlgorithm.NextOutput<Integer>,
		StreamingAlgorithm.Streamer<Integer, State, Integer> {
	
	public static List<Integer> ListifyAsDigits(String s) {
		ArrayList<Integer> a = new ArrayList<Integer>();
		for (char c : s.toCharArray()) {
			int d = Character.digit(c, 36);
			if (d < 0)
				throw new IllegalArgumentException();
			a.add(d);
		}
		return a;
	}
	public static void main(String... args) {
		final String p = args.length >= 1 ? args[0] : "1002210112";
		final int fromRadix = args.length >= 2 ? Integer.parseInt(args[1]) : 3;
		final int toRadix = args.length >= 3 ? Integer.parseInt(args[2]) : 7;
		final List<Integer> inputList = ListifyAsDigits(p);
		
		new BaseConversion(fromRadix, toRadix).stream(inputList);
	}
	
	final int fromRadix; // m'	
	final BigRational fromRadixRat;
	private List<Integer> input;
	private int nextIndex = 0;
	final BigRational ONE = BigRational.valueOf(1);
	private int outputDigit = 0;
	final int toRadix;   // n'
	final BigRational toRadixRat;

	public BaseConversion(int fromRadix, int toRadix) {
		this.fromRadix = fromRadix;
		this.toRadix = toRadix;
		
		this.fromRadixRat = BigRational.valueOf(this.fromRadix);
		this.toRadixRat = BigRational.valueOf(this.toRadix);
	}

	@Override
	public State cons(State b, Integer c) {
		BigRational u = BigRational.valueOf(c).add(b.u.multiply(fromRadixRat));
		BigRational v = b.v.divide(fromRadixRat);
		return new State(u,v);
	}

	@Override
	public boolean hasNextInput() {
		return nextIndex < input.size();
	}

	@Override
	public Integer next(State b) {
		BigInteger i = b.u.multiply(b.v).multiply(toRadixRat).floor();
		return i.intValue();
	}

	@Override
	public Integer nextInput() {
		return input.get(nextIndex++);
	}
		
	@Override
	public void nextOutput(Integer i) {
		out.format("%3d: %1d%n", outputDigit++, i);
	}
	@Override
	public State prod(State b, Integer c) {
		BigRational u = b.u.subtract(BigRational.valueOf(c).divide(b.v.multiply(toRadixRat)));
		BigRational v = b.v.multiply(toRadixRat);
		return new State(u,v);
	}
	
	@Override
	public boolean safe(State b, Integer c) {
		BigInteger fl = b.u.add(ONE).multiply(b.v).multiply(toRadixRat).floor();
		return c == fl.intValue();
	}

	public void stream(List<Integer> input) {
		this.input = input;
		State initialState = new State(BigRational.valueOf(0), BigRational.valueOf(1));
		new StreamingAlgorithm().stream(this, initialState, this, this);
	}
	
	@Override
	public boolean terminate(State b) {
		return false;
	}
}

final class State {
	final public BigRational u;
	final public BigRational v;
	State(BigRational u, BigRational v) {
		this.u = u;
		this.v = v;
	}
}
